/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.internal;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceForURIProvider;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.generator.trace.internal.AbstractTrace;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

public abstract class AbstractTraceForURIProvider<SomeFile, Trace extends AbstractTrace>
implements ITraceForURIProvider {
    private static final Logger log = Logger.getLogger(AbstractTraceForURIProvider.class);
    @Inject
    private IResourceServiceProvider.Registry serviceRegistry;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private CachedTraces cachedTraces;

    protected abstract Trace newAbstractTrace(SomeFile var1);

    protected abstract SomeFile asFile(AbsoluteURI var1, IProjectConfig var2);

    protected abstract AbsoluteURI getAbsoluteLocation(SomeFile var1);

    protected SomeFile asFile(SourceRelativeURI srcRelativeDerivedResource, IProjectConfig project) {
        String[] pathSegments = srcRelativeDerivedResource.getURI().segments();
        Set<? extends ISourceFolder> sourceFolders = project.getSourceFolders();
        for (ISourceFolder iSourceFolder : sourceFolders) {
            URI srcFolderPath = iSourceFolder.getPath();
            URI absoluteURI = srcFolderPath.appendSegments(pathSegments);
            SomeFile result = this.asFile(new AbsoluteURI(absoluteURI), project);
            if (result == null) continue;
            return result;
        }
        URI fromRoot = project.getPath().appendSegments(pathSegments);
        return this.asFile(new AbsoluteURI(fromRoot), project);
    }

    protected abstract List<PersistedTrace> findInverseTraceFiles(SomeFile var1);

    protected abstract PersistedTrace findPersistedTrace(SomeFile var1);

    protected abstract IProjectConfig getProjectConfig(SomeFile var1);

    public Trace getTraceToSource(AbsoluteURI absoluteDerivedResource, IProjectConfig project) {
        SomeFile generatedFile = this.asFile(absoluteDerivedResource, project);
        return this.getTraceToSource(generatedFile);
    }

    public Trace getTraceToSource(SourceRelativeURI srcRelativeDerivedResource, IProjectConfig project) {
        SomeFile generatedFile = this.asFile(srcRelativeDerivedResource, project);
        return this.getTraceToSource(generatedFile);
    }

    public Trace getTraceToSource(SomeFile generatedFile) {
        final PersistedTrace persistedTrace = this.findPersistedTrace(generatedFile);
        if (persistedTrace == null || !persistedTrace.exists()) {
            return null;
        }
        Trace result = this.newAbstractTrace(generatedFile);
        ((AbstractTrace)result).setTraceToSource(true);
        ((AbstractTrace)result).setTraceRegionProvider(new ITraceRegionProvider(){

            @Override
            public AbstractTraceRegion getTraceRegion() {
                AbstractTraceRegion traceRegion = AbstractTraceForURIProvider.this.cachedTraces.getTraceRegion(persistedTrace);
                if (traceRegion == null) {
                    throw new TraceNotFoundException();
                }
                return traceRegion;
            }
        });
        return result;
    }

    public Trace getTraceToTarget(AbsoluteURI absoluteSourceResource, IProjectConfig project) {
        SomeFile sourceFile = this.asFile(absoluteSourceResource, project);
        return this.getTraceToTarget(sourceFile, absoluteSourceResource, this.getProjectConfig(sourceFile));
    }

    public Trace getTraceToTarget(SourceRelativeURI srcRelativeSourceResource, IProjectConfig project) {
        SomeFile sourceFile = this.asFile(srcRelativeSourceResource, project);
        return this.getTraceToTarget(sourceFile, this.getAbsoluteLocation(sourceFile), project);
    }

    public Trace getTraceToTarget(SomeFile sourceFile, final AbsoluteURI absoluteSourceResource, final IProjectConfig projectConfig) {
        final List<PersistedTrace> traceFiles = this.findInverseTraceFiles(sourceFile);
        if (traceFiles.isEmpty() || projectConfig == null) {
            return null;
        }
        Trace result = this.newAbstractTrace(sourceFile);
        ((AbstractTrace)result).setTraceToSource(false);
        IResourceServiceProvider serviceProvider = this.getServiceProvider(absoluteSourceResource);
        final ITraceURIConverter traceURIConverter = serviceProvider.get(ITraceURIConverter.class);
        ((AbstractTrace)result).setTraceRegionProvider(new ITraceRegionProvider(){

            @Override
            public AbstractTraceRegion getTraceRegion() {
                ArrayList<AbstractTraceRegion> result = Lists.newArrayList();
                SourceRelativeURI sourceUriForTrace = traceURIConverter.getURIForTrace(projectConfig, absoluteSourceResource);
                for (PersistedTrace traceFile : traceFiles) {
                    AbsoluteURI generatedFileURI = AbstractTraceForURIProvider.this.getGeneratedLocation(traceFile);
                    if (generatedFileURI == null) {
                        throw new TraceNotFoundException();
                    }
                    AbstractTraceRegion traceRegion = AbstractTraceForURIProvider.this.cachedTraces.getTraceRegion(traceFile);
                    SourceRelativeURI generatedUriForTrace = AbstractTraceForURIProvider.this.getGeneratedUriForTrace(projectConfig, absoluteSourceResource, generatedFileURI, traceURIConverter);
                    if (sourceUriForTrace == null || generatedUriForTrace == null) continue;
                    result.addAll(traceRegion.invertFor(sourceUriForTrace, generatedUriForTrace));
                }
                if (result.isEmpty()) {
                    throw new TraceNotFoundException();
                }
                return AbstractTraceRegion.mergedFrom(result);
            }
        });
        return result;
    }

    protected SourceRelativeURI getGeneratedUriForTrace(IProjectConfig projectConfig, AbsoluteURI absoluteSourceResource, AbsoluteURI generatedFileURI, ITraceURIConverter traceURIConverter) {
        return traceURIConverter.getURIForTrace(projectConfig, generatedFileURI);
    }

    protected IResourceServiceProvider getServiceProvider(AbsoluteURI absoluteSourceResource) {
        return this.serviceRegistry.getResourceServiceProvider(absoluteSourceResource.getURI());
    }

    protected AbsoluteURI getGeneratedLocation(PersistedTrace trace) {
        AbsoluteURI path = trace.getPath();
        String fileName = this.traceFileNameProvider.getJavaFromTrace(path.getURI().toString());
        return new AbsoluteURI(fileName);
    }

    protected TraceFileNameProvider getTraceFileNameProvider() {
        return this.traceFileNameProvider;
    }

    @Singleton
    protected static class CachedTraces {
        @Inject
        private TraceRegionSerializer traceRegionSerializer;
        private Map<CacheKey, AbstractTraceRegion> cache = new LinkedHashMap<CacheKey, AbstractTraceRegion>(32, 0.75f, true){
            private static final long serialVersionUID = 1L;
            final int MAX_SIZE = 20;
            {
                super(x0, x1, x2);
                this.MAX_SIZE = 20;
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<CacheKey, AbstractTraceRegion> eldest) {
                return this.size() > 20;
            }
        };

        protected CachedTraces() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized AbstractTraceRegion getTraceRegion(PersistedTrace traceFile) throws TraceNotFoundException {
            if (traceFile.exists()) {
                CacheKey key = new CacheKey(traceFile);
                AbstractTraceRegion result = this.cache.get(key);
                if (result != null) {
                    return result;
                }
                InputStream contents = null;
                try {
                    contents = traceFile.openStream();
                    result = this.traceRegionSerializer.readTraceRegionFrom(contents);
                    this.cache.put(key, result);
                    AbstractTraceRegion abstractTraceRegion = result;
                    return abstractTraceRegion;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
                finally {
                    try {
                        Closeables.close(contents, true);
                    }
                    catch (IOException iOException) {}
                }
            }
            throw new TraceNotFoundException();
        }

        private static class CacheKey {
            private final AbsoluteURI path;
            private final long timestamp;

            public CacheKey(PersistedTrace source) {
                this.path = source.getPath();
                this.timestamp = source.getTimestamp();
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
                result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                    return false;
                }
                return this.timestamp == other.timestamp;
            }
        }
    }

    protected static interface PersistedTrace {
        public AbsoluteURI getPath();

        public long getTimestamp();

        public InputStream openStream() throws IOException;

        public boolean exists();
    }
}

