/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public class CollectionLiterals {
    @Pure
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    @Pure
    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    @Pure
    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    @Pure
    @SafeVarargs
    public static <T> List<T> newImmutableList(T ... elements) {
        return ImmutableList.copyOf(elements);
    }

    @Pure
    @SafeVarargs
    public static <T> Set<T> newImmutableSet(T ... elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Pure
    @SafeVarargs
    public static <K, V> Map<K, V> newImmutableMap(Pair<? extends K, ? extends V> ... entries) {
        if (entries.length == 0) {
            return CollectionLiterals.emptyMap();
        }
        ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();
        for (Pair<K, V> pair : entries) {
            builder.put(pair.getKey(), pair.getValue());
        }
        return builder.build();
    }

    @Pure
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @Pure
    public static <T> ArrayList<T> newArrayList(T ... initial) {
        if (initial.length > 0) {
            return Lists.newArrayList(initial);
        }
        return CollectionLiterals.newArrayList();
    }

    @Pure
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @SafeVarargs
    @Pure
    public static <T> LinkedList<T> newLinkedList(T ... initial) {
        if (initial.length > 0) {
            return Lists.newLinkedList(Arrays.asList(initial));
        }
        return CollectionLiterals.newLinkedList();
    }

    @Pure
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    @Pure
    public static <T> HashSet<T> newHashSet(T ... initial) {
        if (initial.length > 0) {
            return Sets.newHashSet(initial);
        }
        return CollectionLiterals.newHashSet();
    }

    @Pure
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @SafeVarargs
    @Pure
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... initial) {
        if (initial.length > 0) {
            return Sets.newLinkedHashSet(Arrays.asList(initial));
        }
        return CollectionLiterals.newLinkedHashSet();
    }

    @Pure
    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    @SafeVarargs
    @Pure
    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator, T ... initial) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        if (initial.length > 0) {
            result.addAll(Arrays.asList(initial));
        }
        return result;
    }

    @Pure
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @SafeVarargs
    @Pure
    public static <K, V> HashMap<K, V> newHashMap(Pair<? extends K, ? extends V> ... initial) {
        if (initial.length > 0) {
            HashMap result = new HashMap(CollectionLiterals.capacity(initial.length));
            CollectionLiterals.putAll(result, initial);
            return result;
        }
        return CollectionLiterals.newHashMap();
    }

    @Pure
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @SafeVarargs
    @Pure
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<? extends K, ? extends V> ... initial) {
        if (initial.length > 0) {
            LinkedHashMap result = new LinkedHashMap(CollectionLiterals.capacity(initial.length));
            CollectionLiterals.putAll(result, initial);
            return result;
        }
        return CollectionLiterals.newLinkedHashMap();
    }

    private static int capacity(int initialSize) {
        if (initialSize < 3) {
            return initialSize + 1;
        }
        if (initialSize < 0x40000000) {
            return initialSize + initialSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    @Pure
    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    @SafeVarargs
    @Pure
    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator, Pair<? extends K, ? extends V> ... initial) {
        TreeMap result = new TreeMap(comparator);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    @SafeVarargs
    private static <K, V> void putAll(Map<K, V> result, Pair<? extends K, ? extends V> ... entries) {
        for (Pair<K, V> pair : entries) {
            if (result.containsKey(pair.getKey())) {
                throw new IllegalArgumentException("duplicate key: " + pair.getKey());
            }
            result.put(pair.getKey(), pair.getValue());
        }
    }
}

